DROP PROCEDURE IF EXISTS sp_getGraficaCompras;

delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE sp_getGraficaCompras(
	IN p_fechaDesde DATE, IN p_fechaHasta DATE, IN p_isCategoria INT, IN p_isSubategoria INT, IN p_isClase INT)
BEGIN
	IF p_isCategoria = 1 THEN
		SELECT  -- C.idClase, C.nombre, 
			CAT.idCategoria, CAT.nombre,
			SUM(DOC.monto) AS monto
		FROM ORDEN_COMPRA OC
		INNER JOIN DETALLE_ORDEN DOC ON DOC.idOrdenCompra = OC.idOrdenCompra
		INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
		INNER JOIN CLASE C ON C.idClase = P.idClase
		INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
		INNER JOIN CATEGORIA CAT ON CAT.idCategoria = S.idCategoria
		WHERE OC.estadoRecepcion IN ('EN', 'A') AND CAST(OC.fechaEnvio AS DATE) between p_fechaDesde AND p_fechaHasta
		GROUP BY CAT.idCategoria, CAT.nombre
		ORDER BY monto DESC, CAT.nombre ASC;
    END IF;
        
	IF p_isSubategoria = 1 THEN
		SELECT
			S.idSubcategoria, S.nombre,
			SUM(DOC.monto) AS monto
		FROM ORDEN_COMPRA OC
		INNER JOIN DETALLE_ORDEN DOC ON DOC.idOrdenCompra = OC.idOrdenCompra
		INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
		INNER JOIN CLASE C ON C.idClase = P.idClase
		INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
		WHERE OC.estadoRecepcion IN ('EN', 'A') AND CAST(OC.fechaEnvio AS DATE) between p_fechaDesde AND p_fechaHasta
		GROUP BY S.idSubcategoria, S.nombre
		ORDER BY monto DESC, S.nombre ASC;
    END IF;
        
	IF p_isClase = 1 THEN
		SELECT 
			C.idClase, C.nombre, SUM(DOC.monto) AS monto
		FROM ORDEN_COMPRA OC
		INNER JOIN DETALLE_ORDEN DOC ON DOC.idOrdenCompra = OC.idOrdenCompra
		INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
		INNER JOIN CLASE C ON C.idClase = P.idClase
		WHERE OC.estadoRecepcion IN ('EN', 'A') AND CAST(OC.fechaEnvio AS DATE) between p_fechaDesde AND p_fechaHasta
		GROUP BY C.idClase, C.nombre
		ORDER BY monto DESC, C.nombre ASC;
    END IF;
END
$